reset

xmin=-2.
xmax=2.0
ymin=-2.
ymax=2.

saddle(x,y)=x**2.-y**2.
set table $saddle
set samples 20,20
splot [x=xmin:xmax] [y=ymin:ymax] saddle(x,y)
unset table

fac=0.1
Gx(x,y,z)=2.*x*fac
Gy(x,y,z)=-2.*y*fac
Gz(x,y,z)=0.

set table $grid
set samples 11
set isosamples 11
set parametric
splot [u=xmin:xmax] [v=ymin:ymax] u,v,-9
unset parametric
unset table



set terminal cairolatex eps input # latex
set output 'gradient.clt'




set xrange [xmin:xmax]
set yrange [ymin:ymax]


unset border
unset tics
unset key



set style arrow 1 size 0.05,7 filled linetype 1 linewidth 2

set hidden3d
set view 75,114
set autoscale xy
splot \
 $saddle with lines linetype 1,\
 $grid using 1:2:3:(Gx($1,$2,$3)):(Gy($1,$2,$3)):(Gz($1,$2,$3)) with vectors arrowstyle 1,\
 1/0,1/0,1/0
exit
