reset
set terminal x11

v(a)=a*a*a/4. # volume of the *primitive* cell


############################################
# We expect energy.dat to contain:         #
# a   e(a)                                 #
# with:                                    #
# a     : fcc lattice constant in angstrom #
# e(a)  : energy in rydberg                #
############################################


# NOTE: starting values found by trial&error (!)

#################################################################
# This fits the volume V0 (angstrom^3) (this is the "canonical" #
# Murnaghan eq):                                                #
#                                                               #
#                           V0  DB0                             #
#                         (----)                                #
#               B0 v(a)    v(a)            - B0 V0              #
#  e(a) = E0 + (-------) (--------- + 1) + -------              #
#                 DB0      DB0 - 1         DB0 - 1              #
#################################################################
# B0=10.0e-3  # starting bulk modulus (rydberg/(angstrom^3))
# DB0=5.0     # starting bulk modulus pressure derivative (adimensional)
# V0=v(4.04)  # starting volume (angstrom^3)
# E0=-39.5    # starting energy (rydberg)
# e(a)=E0+(B0*v(a)/DB0)*((((V0/v(a))**DB0)/(DB0-1.))+1.)-(B0*V0)/(DB0-1)
# # we expect energy.dat to contain
# # a   e(a)
# # with:
# # a     fcc lattice constant in angstrom
# # e(a)  energy in rydberg
# fit e(x) 'energy.dat' via E0,V0,B0,DB0


#####################################################################
# This fits directly the fcc lattice constant A0 (angstrom) (simply #
# replace V0 with A0*A0*A0 everywhere):                             #
#                                                                   #
#                          A0 A0 A0                                 #
#                          --------                                 #
#                             4     DB0              A0 A0 A0       #
#                         (--------)           - B0 (--------)      #
#               B0 v(a)      v(a)                       4           #
#  e(a) = E0 + (-------) (------------- + 1) + ---------------      #
#                 DB0        DB0 - 1               DB0 - 1          #
#####################################################################
B0=10.0e-3  # starting bulk modulus (rydberg/(angstrom^3))
DB0=5.0     # starting bulk modulus pressure derivative (adimensional)
A0=4.05     # starting lattice constant (angstrom)
E0=-39.5    # starting energy (rydberg)
e(a)=E0+(B0*v(a)/DB0)*(((((A0*A0*A0/4.)/v(a))**DB0)/(DB0-1.))+1.)-\
   (B0*(A0*A0*A0/4.))/(DB0-1)

fit e(x) 'energy.dat' via E0,A0,B0,DB0

set table $calc
plot [a=3.2:5.] e(a)
unset table

set linestyle 1 linewidth 2 linecolor "red"
set linestyle 2 pointtype 6 pointsize 2 linecolor "blue"

unset key
plot $calc with lines linestyle 1,\
     'energy.dat' with points linestyle 2,\
     1/0


