reset
set terminal x11
efermi=7.9349  # from scf.out

# IMPORTANT
# The DOS calculated by QE is for the volume of the primitive cell, ie:
# 
#   NOT             g(E)=(1/V) (dN(E)/dE)
#   BUT RATHER      g(E)V=dN(E)/dE
# 
# where V is the volume of the primitive cell. This is clearly stated in
# this thread:
# https://www.mail-archive.com/users@lists.quantum-espresso.org/msg41338.html
# 
# So, in order to compare the DOS for aluminum calculated by QE with the
# DOS for the MPTL model, the latter has to be multiplied by the volume
# of the primitive cell (of aluminum), as per above



# fac=(unit cell volume)*(1/(2*pi^2))*((2*m/(hbar^2))^(3/2)) in 1/eV
#                         ---|---          
# note the 2 in place of 4: monoelectronic states, NOT k states
# unit cell volume from QE's output: 111.3277 (bohr)^3=16.497063 ang^3
fac=0.11238089 # in 1/eV


expo=0.5
shift=5. # shift to fit QE data
mptl(x)=fac*((x+shift)**expo)
fit mptl(x) 'pdos.d/pwscf.pdos_tot' using 1:2 via shift

set table $calc
plot [x=-0.9*shift:22.] mptl(x)
unset table

set table $occupied
plot 'pdos.d/pwscf.pdos_tot' using 1:($1<=efermi?$2:1/0)
unset table

set linestyle 1 linetype 1 linewidth 2 linecolor rgbcolor "blue"
set linestyle 2 linetype 1 linewidth 2 linecolor rgbcolor "red"

unset key
plot \
     $occupied with filledcurves x1 fillcolor "grey",\
     'pdos.d/pwscf.pdos_tot' using 1:2 with lines linestyle 1,\
     $calc with lines linestyle 2,\
     1/0


exit
(1/(2*pi^2))*sqrt(((2*electronmass/(hbar^2))^3*eV))
